#!/usr/bin/env python
# Sort By Priority
# 041104 - first version of this script

def SortOnColumn(self, columnname):
    rid = self.ReportID  # current report
    trep = Data.Database['Report']
    trow = Data.Database['ReportRow']
    ttyp = Data.Database['ReportType']
    tid = trep[rid].get('ReportTypeID')
    if not tid: return  # all reports must have a type

    rlist = Data.GetRowList(rid)

    if len(rlist) < 2 : return  # don't sort if no rows or one row

    tb = ttyp[tid].get('TableB')

    seq = {}  # capture current sequence
    for i, id in enumerate(rlist):
        seq[id] = i

    def mycmp(a, b):
        rr = trow[a]
        tn, tid = rr.get('TableName'), rr.get('TableID')
        if tn and tid:
            val = Data.Database[tn][tid].get(columnname)
        else:
            val = None
        a1 = (val, seq[a])

        rr = trow[b]
        tn, tid = rr.get('TableName'), rr.get('TableID')
        if tn and tid:
            val = Data.Database[tn][tid].get(columnname)
        else:
            val = None
        b1 = (val, seq[b])

        return cmp(a1, b1)

    rlist.sort(mycmp)
    Data.ReorderReportRows(rid, rlist)
    Data.SetUndo("Sort of Report Rows")

SortOnColumn(self, 'Priority')
SortOnColumn(self, 'Date Resolved')
